Новости
*******

Релиз 8.12.0
============

   * Объединить все исполняемые файлы в одну 'nncp' команду.  Вам стоит
     добавить символические ссылки всех 'nncp-*' команд на неё.

   * Предотвратить возможно обхода путей во время операций freq и
     сохранения файлов.  До этого злонамеренный путь в пакетах мог
     запросить или перезаписать файл вне freq или incoming директорий.

Релиз 8.11.0
============

   * Исправлена невозможность сборки под Go 1.22.  Теперь это
     минимальная версия.

   * Обновлены зависимые библиотеки.

   * 'go.cypherpunks.ru' имя Go модуля изменено на 'go.cypherpunks.su',
     так как домен скоро исчезнет.

Релиз 8.10.0
============

   * Обновлены зависимые библиотеки, включая Yggdrasil (его сеть начала
     использовать v0.5).

Релиз 8.9.0
===========

   * 'nncp-toss' команда имеет '-gen-ack' опцию.  'nncp-daemon',
     'nncp-caller', 'nncp-call' команды имеют '-autotoss-gen-ack' опцию.
     Они автоматически генерируют ACK пакеты и сохраняют соответствующие
     'spoo/tx/ack/' ссылки на них, чтобы их можно было удалить после
     передачи.

   * 'autotoss-gen-ack' появился в конфигурации call.  'ack' секция
     появилась в конфигурации ноды.

   * 'nncp-rm' команда имеет '-ack' опцию для удаления пакетов на
     которые ссылаются 'spool/tx/ack/' файлы созданные во время toss.

   * 'redo' система сборки более не требуется при установке, так как по
     сути нет зависимостей, только компиляция Go кода.

   * Обновлены некоторые зависимости.

Релиз 8.8.3
===========

   * Исправлена 'nncp-reass' команда, которая некорректно сообщала о
     плохом размере последнего куска файла если он был кратен размеру
     chunk-а.

   * Обновлены зависимости.  Теперь требуется Go 1.20+.

Релиз 8.8.2
===========

   * Обновлена библиотека для работы с Yggdrasil, а также несколько
     других.

Релиз 8.8.1
===========

   * Исправлено падение 'nncp-daemon' при неопознанном подключении и
     включённом '-autotoss'.

   * Обновлены зависимые библиотеки.

Релиз 8.8.0
===========

   * Исправлена невозможность сборки под Go 1.19.

   * Минимальная требуемая версия Go 1.17.

   * Обновлены зависимые библиотеки.

Релиз 8.7.2
===========

   * Более интуитивное, понятное и немного более гибкое поведение
     'nncp-rm'.

   * 'nncp-rm' также удаляет соответствующий 'hdr/' файл для каждого
     удалённого пакета.

Релиз 8.7.1
===========

   * 'nncp-xfer' теперь корректно проверяет наличие 'seen/' файлов для
     входящих пакетов.

Релиз 8.7.0
===========

   * 'nncp-ack' не подтверждает ACK-пакеты, предотвращая бесконечную
     петлю из ACK-ов.

   * В прошлом, 'nncp-ack' не удаляла соответствующие 'hdr/' файлы.

   * 'nncp-rm' теперь берёт список пакетов из 'stdin', при использовании
     '-pkt' опции.

   * 'nncp-ack' теперь генерирует список ACK пакетов, которые были
     созданы, что может использоваться в качестве ввода для 'nncp-rm'
     команды, чтобы удалить исходящие ACK пакеты.

Релиз 8.6.0
===========

   * 'nncp-xfer' проверяет сходится ли контрольная сумма скопированного
     локально пакета и исходного.

   * 'nncp-call' имеет плохой код возврата если в очередях на приём и
     отправку остаются незаконченные задания.

   * Появилась 'nncp-ack' команда, которая отправляет явное
     подтверждение доставки пакета (ACK пакет).  Это подтверждение
     удаляет упомянутый пакет из исходящего spool-а.

   * Появилась возможность отключения 'fsync' операции '$NNCPNOSYNC=1'
     переменной окружения.

   * Добавлены разнообразные индексы в документации, что должно помочь
     при поиске в ней.

Релиз 8.5.0
===========

   * Исправлена работоспособность 'nncp-bundle'.

   * По ошибке '-mcd-wait' опция у 'nncp-call' была включена по
     умолчанию.

   * Возможность переопределять внутренний timeout по умолчанию для
     протокола синхронизации через '$NNCPDEADLINE' переменную окружения.
     Может быть полезно для каналов с очень большими задержками.

   * NNCP собирается на OpenBSD.

Релиз 8.4.0
===========

   * Имена интерфейсов относящихся к multicast ('mcd-listen' и
     'mcd-send' опции конфигурации) теперь являются регулярными
     выражениями.  По умолчанию 'nncp-cfgnew' не комментирует их теперь
     и прописывает '.*' имя интерфейса.

   * У 'nncp-call' команды появился '-mcd-wait' аргумент, позволяющий
     дожидаться multicast сообщения об адресе ноды.

   * 'nncp-file' команда пропускает всё что не является регулярным
     файлом или директорией во время создания pax-архива.

Релиз 8.3.0
===========

   * Исправлена возможность сборки на 32-бит системах.

Релиз 8.2.0
===========

   * Yggdrasil использует IPv6+TCP сетевой стэк написанный полностью на
     Go, вместо голого μTP транспортного протокола, делая возможным
     работу в качестве обычного TCP сервера внутри overlay сети.

   * Конфигурационные строки Yggdrasil вида 'prv;bind1,bind2;pub...'
     заменены на URL-подобные
     ('yggdrasils://PRV?bind=BIND1&bind=BIND2&pub=PUB').

   * Возможно передавать параметры Yggdrasil конфигурации связанные с
     multicast.

   * 'nncp-daemon' может слушать одновременно и на TCP и на
     Yggdrasil-управляемом сокетах.

   * Слушание на endpoint сокете для пиринга в 'nncp-daemon' опционально
     - вы можете быть доступны и через связь с peer-ами.

Релиз 8.1.0
===========

   * 'nncp-cfgdir' команда не требует обязательного наличия 'self'
     секции конфигурационного файла.

   * Появилась возможность работы в качестве клиента overlay сети
     Yggdrasil, используя online протокол поверх неё.

Релиз 8.0.2
===========

   * Исправлена возможность отправки мультивещательных пакетов.

Релиз 8.0.1
===========

   * Исправлено некорректное вычисление 'freq.chunked' значения, при
     отсутствии которого всё равно форсированно включалась chunked
     передача.

   * Исправлено некорректное вычисление значения полного размера файла в
     '.nncp.meta'.

Релиз 8.0.0
===========

   * *Несовместимое* изменение формата зашифрованных пакетов: размеры
     полезной нагрузки и дополнения посылаются прямо внутри
     зашифрованного потока.  Это даёт возможность потоково создавать
     шифрованные пакеты, без знания размеров заранее, без создания
     временного файла или буферизации в памяти.

   * Производится корректная проверка дополнения зашифрованного пакета.
     Это не критичная проблема, но прежде ни размер, ни значение
     дополнения не были аутентифицированы, позволяя циклично откусывать
     по байту с конца и узнавать размер полезной нагрузки, наблюдая за
     реакцией по обработке такого зашифрованного пакета.

   * 'nncp-exec' больше не имеет '-use-tmp' опции, из-за совместимого с
     потоковой работой формата зашифрованных пакетов.

   * У 'nncp-file' и 'nncp-exec' команд появилась опция '-maxsize',
     ограничивающая максимальный результирующий размер зашифрованного
     пакета (возвращая ошибку если он превышен).  Может быть полезно,
     так как размер полезной нагрузки может быть неизвестен заранее.

Релиз 7.7.0
===========

   * Экспериментальная поддержка 'kqueue' и 'inotify' оповещений об
     изменениях в spool директориях, для сокращения накладных расходов
     на их частое чтение.

   * '.seen' и '.hdr' файлы находятся в 'seen/' и 'hdr/' поддиректориях
     теперь, дабы ускорить сканирование spool областей.  Необходима
     миграция текущих файлов:

          $ find $NNCPSPOOL -type f -name "*.hdr" -exec rm {} +

          $ find $NNCPSPOOL -type d -name rx | while read rx ; do
              cd $rx
              mkdir -p seen
              find . -type f -name "*.seen" | while read fn ; do
                  mv $fn seen/${fn%.seen}
              done
          done

          $ find $NNCPSPOOL -type d -name area | while read area ; do
              find $area -type f -name "*.seen" | while read fn ; do
                  mv $fn ${fn%.seen}
              done
          done

Релиз 7.6.0
===========

   * Журналирование может производиться в назначенный открытый файловый
     дескриптор ('$NNCPLOG=FD:5' например).  Что дружелюбно к
     использованию под 'daemontools'.

   * Добавлены дополнительные проверки наличия публичных ключей в
     конфигурационном файле, предотвращающие падения некоторых команд.

Релиз 7.5.1
===========

   * NNCP собирается на NetBSD.

Релиз 7.5.0
===========

   * 'nncp-daemon' соблюдает UCSPI-TCP интерфейс, благодаря чему в
     журнале будет присутствовать адрес удалённой системы (при запуске
     под совместимой утилитой).  Желательно применять '-ucspi' опцию
     вместо '-inetd'.

   * 'nncp-call' может быть UCSPI-TCP клиентом, используя '-ucspi'
     опцию.

   * Не выходить если не получается слушать на каком-либо MCD сетевом
     интерфейсе - только предупреждать об ошибке.

Релиз 7.4.0
===========

   * Исправлена работоспособность MCD при одновременном использовании
     'nncp-daemon' и 'nncp-caller'.

Релиз 7.3.2
===========

   * 'hjson-cli' утилита теперь собирается в vendor-режиме.

Релиз 7.3.1
===========

   * Исправлена проблема с возможно остающимся открытым файловым
     дескриптором в online командах.

   * Существенно снижено потребление памяти MTH хэширования.

Релиз 7.3.0
===========

   * Поправлены проблемы работоспособности на 32-бит системах с большими
     файлами.

   * Возможность использовать конфигурацию в виде директории с набором
     файлов.  Появилась команда 'nncp-cfgdir'.

Релиз 7.2.1
===========

   * Небольшие оптимизации в online командах.

Релиз 7.2.0
===========

   * Появилась 'nncp-trns' команда для ручного создания транзитных
     пакетов.

   * Если у целевой ноды транзитного пакета задан 'via' маршрут, то
     использовать его, а не игнорировать.

   * Не отправлять multicast пакет оригинатору сообщения, очевидно точно
     видящего свой собственный пакет.

   * Намного меньшее потребление памяти во время MTH хэширования когда
     смещение равно нулю: когда пакет не является докачиванием, а
     например проверяется 'nncp-check' командой.

Релиз 7.1.1
===========

   * Исправлено падение при 'fsync' директорий после создания '.seen'
     файлов.

Релиз 7.1.0
===========

   * Появилась возможность мультивещательной (multicast) рассылки
     пакетов.  Реализовано всего лишь дополнительным типом простых
     пакетов и изменением 'nncp-toss', 'nncp-file' и 'nncp-exec' команд.

   * Исправлена работоспособность 'nncp-file' и 'nncp-exec' команд
     использующих временный файл ('stdin' и '-use-tmp').

   * Исправлен пропадающий плохой код возврата в 'nncp-exec' команде.

   * Исправлено некорректное генерирование '.hdr' при использовании
     транзитных пакетов.

   * У 'nncp-rm' команды появилась '-all' опция, применяемая ко всем
     нодам сразу.

   * У 'nncp-check' команды появилась '-cycle' опция, вводящая проверку
     в бесконечный цикл.

   * У 'nncp-rm' команды можно указывать alias-ы имён нод.

   * 'nncp-pkt' может парсить '.hdr' файлы.

Релиз 7.0.0
===========

   * Минимальная требуемая версия Go 1.13.

   * Хэширование с BLAKE3 на базе деревьев Меркле (Merkle Tree Hashing,
     MTH) используется вместо BLAKE2b.  Из-за этого, обратно
     *несовместимое* изменение формата шифрованных файлов (всего что
     находится в spool области) и формата '.meta' файла при chunked
     передаче.

     Текущая реализация далека от оптимальной: в ней нет
     распараллеливания вычислений и имеет повышенное потребление памяти:
     около 512 KiB на каждый 1 GiB данных файла.  Будущая оптимизация
     производительности и потребления памяти не должна привести к
     изменению формата пакетов.  Но это всё равно в несколько раз
     быстрее BLAKE2b.

   * Из-за использования MTH, докачиваемые в online режиме файлы
     потребуют чтения с диска только предшествующей части, а не
     полностью всего файла, как было прежде.

   * Добавлена 'nncp-hash' утилита для вычисления MTH хэша файла.

   * В шифрованных пакетах BLAKE2 KDF и XOF функции заменены на BLAKE3.
     Ещё уменьшая количество примитивов.  А также заголовок шифрованного
     файла теперь является ассоциированными данными при шифровании.

   * MultiCast Discovery использует ff02::4e4e:4350 адрес вместо
     ff02::1.

   * 'nncp-cfgenc' ошибочно трижды спрашивал парольную фразу при
     шифровании.

   * 'nncp-stat' выводит сводку о частично скачанных пакетах.

   * Обновлены зависимые библиотеки.

Релиз 6.6.0
===========

   * 'nncp-daemon', 'nncp-call' и 'nncp-caller' ожидают завершения всех
     процессов фоновой проверки контрольных сумм, после того как
     соединение закрыто.

   * Добавлена возможность определения адреса через multicast оповещение
     в локальной сети, так называемый MCD (MultiCast Discovery).

Релиз 6.5.0
===========

   * Исправлено падение в 'nncp-daemon' когда SP рукопожатие не было
     успешно.

   * Исправлено возможное игнорирование плохого кода возврата
     автоматического tosser.

   * Исправлена гонка при закрытии файловых дескрипторов во время
     завершения работы online протокола, которая могла привести к ошибке
     записи принятого фрагмента пакета.

   * Убирать показ прогресса передачи пакетов когда вызов уже завершён в
     'nncp-daemon', 'nncp-call' и 'nncp-caller'.

Релиз 6.4.0
===========

   * Исправлена возможная гонка в online протоколе, приводящая к падению
     программы.

Релиз 6.3.0
===========

   * Исправлено возможное падение программы во время показа прогресса
     online протокола.

Релиз 6.2.1
===========

   * В трёх местах сообщений журналов по ошибке остались лишние '%s'.

Релиз 6.2.0
===========

   * Возвращена работоспособность '-autotoss*' опций 'nncp-caller'.

   * Очередной рефакторинг и упрощение системы журналирования.  Не
     должно быть видимых изменений для конечного пользователя.

Релиз 6.1.0
===========

   * Оптимизация: большинство команд теперь не держат открытыми файловые
     дескрипторы.  Прежде вы легко могли выйти за пределы максимально
     допустимого количества открытых файлов, если у вас было много
     пакетов в spool директории.

   * Оптимизация: не закрывать файловый дескриптор файла который мы
     качаем.  Прежде каждый его кусочек приводил к дорогим open/close
     вызовам.

   * Скачиваемые в режиме online файлы теперь сохраняются с '.nock'
     суффиксом (non-checksummed), ожидая пока либо 'nncp-check', либо
     online демоны не выполнят проверку целостности.

   * Оптимизация: для файлов, скачивание которых не было продолжено,
     сразу же вычисляет контрольная сумма, пропуская промежуточный
     '.nock' шаг.

   * Возможность хранения заголовков зашифрованных пакетов в '.hdr'
     файлах, рядом с самими пакетами.  Это может существенно повысить
     скорость получения списка пакетов на файловых системах с большим
     размером блока.

Релиз 6.0.0
===========

   * Журнал использует человеко-читаемый и легко обрабатываемый машиной
     recfile (https://www.gnu.org/software/recutils/) формат для своих
     записей, вместо структурированных строчек RFC 3339.  Старый формат
     журналов не поддерживается 'nncp-log'.

   * Работоспособность '-autotoss*' опции с '-inetd' режимом
     'nncp-daemon'.

   * 'when-tx-exists' опция вызова в конфигурационном файле позволяет
     делать вызов только если имеются исходящие сообщения.  Совмещённая
     с cron выражением содержащим секунды, это можно использовать как
     возможность вызова только при появлении исходящих пакетов.

   * 'nncp-cronexpr' команда позволяет проверить корректность и
     ожидаемый результат от указанного cron выражения.

Релиз 5.6.0
===========

   * '-autotoss*' опции запускают tosser не после завершения вызова, а
     во время него ежесекундно.

   * В 'calls' секции конфигурации появились опции 'autotoss',
     'autotoss-doseen', 'autotoss-nofile', 'autotoss-nofreq',
     'autotoss-noexec', 'autotoss-notrns'.  Вы можете настраивать опции
     автоматического tosser для каждого вызова.

   * Использовать vendoring вместо переопределения '$GOPATH' во время
     установки tarball, так как текущая минимальная версия Go это 1.12,
     поддерживающая модули.

Релиз 5.5.1
===========

   * Уважать '$BINDIR', '$INFODIR' и '$DOCDIR' переменные окружения в
     'config' во время установки.

Релиз 5.5.0
===========

   * Исправления ошибок в 'nncp-call(er)'/'nncp-daemon', 'nncp-bundle',
     'nncp-stat' командах.

   * У команды 'nncp-rm' появились '-dryrun' и '-older' опции.

   * У команды 'nncp-exec' появились '-use-tmp' и '-nocompress' опции.
     Несжатые пакеты не совместимы с предыдущими версиями NNCP.

   * У команд 'nncp-call', 'nncp-caller' и 'nncp-daemon' появились
     '-autotoss*' опции для запуска tosser после завершения звонка.

   * Обновлены зависимые библиотеки.  Минимальная требуемая версия Go
     1.12.

Релиз 5.4.1
===========

   * Исправлена ошибка с учётом 'SENDMAIL' переменной при сборке.

Релиз 5.4.0
===========

   * Обновлены зависимые библиотеки.

   * Система сборки переведена с Makefile-ов на redo
     (http://cr.yp.to/redo.html).  Это не должно повлиять на
     мейнтейнеров пакетов, так как минимальная реализация 'redo'
     включена в tarball.

Релиз 5.3.3
===========

   * Больше различных проверок в коде на ошибки.

   * Обновлены зависимые библиотеки.

Релиз 5.3.2
===========

   * Исправлена некорректная логика 'onlinedeadline' timeout-а, при
     котором соединение могло не учитывать факты прихода пакетов и
     обрывать связь.

Релиз 5.3.1
===========

   * Исправлена работоспособность 'onlinedeadline' с адресами вызова
     использующими внешние команды ("|somecmd").

   * 'nncp-stat' имеет опцию '-pkt' показывающую информацию по каждому
     пакету в spool.

Релиз 5.3.0
===========

   * Сообщения прогресса содержат префикс, поясняющий выполняемое
     действие.

   * Исправлено не происходящее дополнение (padding) handshake
     сообщений.

   * Завершать все порождаемые в SP протоколе горутины, меньше утечек
     памяти.

   * SP протокол порождает меньше вызовов записей (соответственно, и TCP
     пакетов) в сокет.

   * Проверять 'onlinedeadline' и 'maxonlinetime' ежесекундно,
     независимо от чтения из сокета (раз в 10 секунд в худшем случае).

   * Раз в минуту, если нет более никакого другого трафика, посылаются
     PING пакеты в SP-соединении.  Это позволит быстрее понимать что
     соединение более не работоспособно.

   * 'nncp-toss' использует lock-file для предотвращения одновременной
     обработки зашифрованных пакетов.

Релиз 5.2.1
===========

   * Исправлена обработка ошибки SP протокола, иногда вызывающая панику
     программы.

Релиз 5.2.0
===========

   * Большинство команд по умолчанию показывают однострочный прогресс
     выполнения операции.  Появились '-progress', '-noprogress' опции
     командной строки, 'noprogress' опция конфигурационного файла.

   * Исправлен некорректный код возврата 'nncp-check' команды, который
     возвращал ошибку когда всё хорошо.

   * Проверка свободного места для пакетов, во время выполнения
     'nncp-bundle -rx'.

Релиз 5.1.2
===========

   * Исправлена *критичная* уязвимость: аутентификация online нод могла
     приводить к некорректной идентификации удалённой стороны, позволяя
     скачивать чужие зашифрованные пакеты.

   * Исправлена ошибка: в новосозданных конфигурационных файлах,
     приватный публичный ключ Noise были поменяны местами, что приводило
     к невозможности online аутентификации нод.

   * Явная синхронизация ('fsync') директорий для гарантированного
     переименования файлов.

Релиз 5.1.1
===========

   * Исправлена работоспособность 'nncp-file' с '-chunked 0' опцией.

Релиз 5.1.0
===========

   * 'nncp-file' может отправлять директории, автоматически на лету
     создавая pax архив.

   * Во время создания исходящих сообщений проверяется наличие
     свободного места на файловой системе.

   * 'freq', 'freqminsize', 'freqchunked' опции конфигурационного файла
     заменены на структуру 'freq: {path: ..., minsize: ..., chunked:
     ...}'.

   * Добавлена 'freq.maxsize' опция конфигурационного файл, запрещающая
     ответ на файловый запрос больше заданного размера.

   * Возможность оповещения об успешно выполненных командах (exec) через
     'notify.exec' опцию конфигурационного файла.

Релиз 5.0.0
===========

   * *Несовместимое* изменение формата конфигурационного файла: YAML
     заменён на Hjson, из-за его гораздо большей простоты, без заметной
     потери функционала и удобства.

   * *Несовместимое* изменение формата простых пакетов.  Работа со
     старыми версиями не поддерживается.  'zlib' сжатие заменено на
     'Zstandard', так как оно значительно быстрее и эффективнее, не
     смотря на то, что версия библиотеки ещё не проверена временем.

   * Возможность соединяться с удалёнными нодами не только по TCP, но и
     через pipe вызов сторонней команды.

   * 'nncp-cfgnew' генерирует конфигурационный файл с множеством
     комментариев.  Можно использовать '-nocomments' опцию для старого
     поведения.

   * Дубликаты имён файлов имеют суффикс '.CTR', вместо 'CTR', чтобы
     избежать возможных коллизий с '.nncp.chunkCTR'.

   * Возможность переопределить umask процесса через опцию
     конфигурационного файла.

   * По умолчанию файлы и директории создаются с 666/777 правами
     доступа, позволяя управлять ими 'umask'-ом.

   * Обновлены зависимости.

   * Полное использование Go модулей для управления зависимостями
     (используется 'go.cypherpunks.ru/nncp/v5' namespace).

   * Отмена автоматического использования более новых версий GNU GPL
     (лицензия проекта GNU GPLv3-только).

Релиз 4.1
=========

   * Восстановлена работоспособность на GNU/Linux системах и Go версии
     1.10.

Релиз 4.0
=========

   * *Несовместимое* изменение формата зашифрованных и eblob пакетов:
     используется AEAD режим шифрования с 128 КиБ блоками, так как
     раньше 'nncp-toss' не проверял MAC зашифрованного пакета прежде чем
     отсылать дешифрованные данные внешней команде.  Старые версии не
     поддерживаются.

   * Проверка доступного места перед копированием во время работы
     'nncp-xfer', 'nncp-daemon', 'nncp-call(er)'.

   * 'nncp-call' имеет возможность только показывать список пакетов на
     удалённой машине, без их передачи.

   * 'nncp-call' имеет возможность передавать только чётко указанные
     пакеты.

   * Восстановлена работоспособность 'xxrate' настройки в 'calls' секции
     конфигурационного файла.

   * Зависимые библиотеки обновлены.

   * Небольшие исправления ошибок.

   * Начало использования 'go.mod' подсистемы.

Релиз 3.4
=========

   * 'nncp-daemon' может быть запущен как 'inetd'-служба.

Релиз 3.3
=========

   * 'nncp-daemon', 'nncp-call', 'nncp-caller' проверяют существование
     '.seen' файла и расценивают его как то, что файл уже был скачан.
     Возможно передача данных была осуществлена сторонним способом и
     удалённая сторона должна быть оповещена об этом.

   * Если более высокоприоритетный пакет попадает в спул, то
     'nncp-daemon' добавит его в очередь отправки первым, прерывая
     низкоприоритетные передачи.

   * К средствам связанным с online-соединениями ('nncp-daemon',
     'nncp-call', 'nncp-caller') добавлен простой ограничитель скорости.

   * Возможность задания приоритета символьными обозначениями: NORMAL,
     BULK+10, PRIORITY-5, итд.

   * Изменены значения приоритетов по-умолчанию: для 'nncp-exec' с 64 на
     96, для 'nncp-freq' с 64 на 160, для 'nncp-file' с 196 на 224.

Релиз 3.2
=========

   * *Несовместимое* изменение формата _bundle_ архивов и
     работоспособность 'nncp-bundle' команды с Go 1.10+.  Bundle должен
     быть корректным tar архивом, но Go 1.9 делал его недействительным
     из-за длинных путей внутри.  NNCP нечаянно был зависим от этой
     баги.  Явное добавление 'NNCP/' директории в архив восстанавливает
     работоспособность с корректными tar архивами.

Релиз 3.1
=========

   * Возможность отключать пересылку через промежуточные ноды используя
     -via - опцию командной строки.

Релиз 3.0
=========

   * *Несовместимое* изменение формата простых пакетов.  Работа со
     старыми версиями не поддерживается.

   * Добавлена возможность удалённого исполнения команд, путём
     конфигурирования 'exec' опции конфигурационного файла и
     использования команды 'nncp-exec':
        * Команда 'nncp-mail' заменена более гибкой и широкой
          'nncp-exec'.  Вместо вызова nncp-mail NODE RECIPIENT нужно
          использовать nncp-exec NODE sendmail RECIPIENT.
        * 'sendmail' опция конфигурационного файла заменена на более
          гибкую 'exec'.  'sendmail: [...]' нужно заменить на 'exec:
          sendmail: [...]'.

   * Возможность переопределить 'via' опцию конфигурации для целевого
     узла через '-via' опцию командной строки для следующих команд:
     'nncp-file', 'nncp-freq', 'nncp-exec'.

   * Chunked файлы, меньшего размера чем указанный chunk, отправляются
     просто в виде одного файла.

   * Exec команды вызываются с дополнительными переменными окружения
     '$NNCP_NICE' и '$NNCP_SELF'.

   * Отправляемые файлы в ответ на запрос имеют приоритет указанный в
     запросе.  Указать их желаемый приоритет во время вызова 'nncp-freq'
     можно аргументом '-replynice'.

   * Команде 'nncp-toss' можно сказать не обрабатывать определённые типы
     пакетов, за счёт опций '-nofile', '-nofreq', '-noexec', '-notrns'.

   * По-умолчанию 'nncp-file' команда для '-minsize'/'-chunked' опций
     использует 'FreqMinSize'/'FreqChunked' из конфигурационного файла.
     Это можно отключить указав нулевое значение.

Релиз 2.0
=========

   * *Несовместимое* изменение формата зашифрованных и eblob пакетов.
     Работа со старыми версиями не поддерживается.

   * Алгоритм шифрования Twofish заменён на ChaCha20.  Он намного
     быстрее.  Одним криптографическим примитивом меньше.

   * HKDF-BLAKE2b-256 KDF алгоритм заменён на BLAKE2Xb XOF. Ещё одним
     криптографическим примитивом меньше (предполагая, что BLAKE2X
     практически идентичен BLAKE2).

Релиз 1.0
=========

   * *Несовместимое* изменение формата зашифрованных пакетов.  Работа со
     старыми версиями не поддерживается.

   * 'nncp-bundle' команда может создавать потоки зашифрованных пакетов
     или потреблять их.  Это полезно когда речь идёт о 'stdin'/'stdout'
     методах передачи (например запись на CD-ROM без создания
     промежуточного подготовленного ISO образа или работа с ленточными
     накопителями).

   * 'nncp-toss' команда может создавать '.seen' файлы, предотвращая
     приём дублированных пакетов.

   * В команде 'nncp-call' разрешается иметь только одного обработчика
     контрольной суммы в фоне.  Это полезно когда тысячи маленьких
     входящих пакетов могут создать много горутин.

   * Возможность переопределить путь до spool директории и файла журнала
     через аргумент командной строки или переменную окружения.

   * 'nncp-rm' команда может удалять все исходящие/входящие, '.seen',
     '.part', '.lock' и временные файлы.

Релиз 0.12
==========

   * Команда sendmail вызывается с '$NNCP_SENDER' переменной окружения.

Релиз 0.11
==========

   * Вывод команды 'nncp-stat' отсортирован по имени ноды.

Релиз 0.10
==========

   * 'DST' аргумент 'nncp-freq' команды теперь опционален.  По-умолчанию
     будет подставлен последний элемент 'SRC' пути.

Релиз 0.9
=========

   * Исправлена обработка '-rx'/'-tx' опций 'nncp-call' команды.  Они
     игнорировались.

Релиз 0.8
=========

   * Небольшое исправление ошибки в команде 'nncp-file', где опция
     '-minsize' для передачи без разбиения на части была в байтах, а не
     KiB-ах.

Релиз 0.7
=========

   * Возможность предоставлять данные для 'nncp-file' через стандартный
     ввод, используя временный зашифрованный файл для этого.

   * Появилась возможность передачи файлов разбитых на части, с
     сопутствующей 'nncp-reass' командой и 'freqchunked' опцией
     конфигурационного файла.  Полезно для передачи больших файлов через
     маленькие устройства хранения.

   * 'freqminsize' опция конфигурационного файла, аналогичная
     '-minsize'.

   * Опция '-force' команды 'nncp-xfer' переименована в '-mkdir' для
     ясности.

   * Опция '-minsize' задаётся в KiB, а не байтах, для удобства.

   * Команда 'nncp-newcfg' переименована в 'nncp-cfgnew', а
     'nncp-mincfg' в 'nncp-cfgmin', для того чтобы они имели общий
     префикс и были сгруппированы для удобства.

   * Появилась команда 'nncp-cfgenc', позволяющая шифровать/дешифровать
     конфигурационный файл, чтобы безопасно его хранить без
     использования OpenPGP или других подобных инструментов.

   * Обновлены зависимые криптографические библиотеки.

Релиз 0.6
=========

   * Появилась небольшая команда 'nncp-rm'.
   * Обновлены зависимые криптографические библиотеки.

Релиз 0.5
=========

   * Тривиальное небольшое исправление в значениях приоритетов
     по-умолчанию в 'nncp-file' и 'nncp-freq' командах.

Релиз 0.4
=========

   * Небольшое исправление в 'nncp-call', 'nncp-caller', 'nncp-daemon':
     иногда они могли падать с segmentation fault ошибкой (данные не
     терялись).

   * 'nncp-newnode' переименована в 'nncp-newcfg' - это короче и удобнее
     для использования.

   * Появилась команда 'nncp-mincfg': вспомогательная утилита
     позволяющая создать минималистичный урезанный конфигурационный файл
     без приватных ключей, что полезно во время использования
     'nncp-xfer'.

Релиз 0.3
=========

   * Исправлена совместимость с Go 1.6.

Релиз 0.2
=========

   * *Несовместимое* изменение формата пакета (магическое число тоже
     изменено): поле размера пакета шифруется и не посылается в открытом
     виде.

   * '-minsize' опция даёт возможность автоматически дополнять исходящие
     пакеты до указанного минимального размера.

   * 'nncp-daemon' и 'nncp-call'/'nncp-caller' всегда в фоне проверяют
     появление исходящих _tx_ пакетов пока подключены.  Удалённая
     сторона сразу же оповещается об этом.

   * '-onlinedeadline' опция даёт возможность выставления timeout-а на
     неактивность в online соединении, когда оно должно быть отключено.
     Она может быть использована для сохранения соединения на долгое
     время.

   * '-maxonlinetime' опция даёт возможность указания максимального
     возможного времени жизни соединения.

   * Появилась 'nncp-caller' команда: клиент TCP-демона работающий по
     cron-у.

   * 'nncp-pkt' команда может разжимать данные.

